---
--- Sp_respondentincdecunused
---
	
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_respondentincdecunused]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[Sp_respondentincdecunused]
GO


CREATE PROCEDURE [dbo].[Sp_respondentincdecunused]
                @ProjectId  INT,
                @userId     INT,
                @Respondent VARCHAR(10),
                @operation  BIT
AS
--Set the Operation Direction
DECLARE  @CNT INT
IF @operation = 1
      SET @CNT = 1
ELSE
      SET @CNT = -1
-- Update unused for the respondent stratum
UPDATE Quota
SET    QtUnused = CASE WHEN ( ( Quota.QtUnused + ( @CNT * COALESCE(IncrementValue,1) ) ) < 0 )
                              THEN 0 
                              ELSE ( Quota.QtUnused + ( @CNT * COALESCE(IncrementValue,1) ) ) END
FROM   Quota  
                  inner join Stratum
                        on Quota.QtQuotaId = Stratum.StrQuotaId
WHERE   Stratum.strrespondent = @Respondent
-- Update the Main unused
UPDATE Quota
SET    qtunused = CASE WHEN ( qtunused + @CNT < 0 )
      THEN 0
      ELSE (qtunused + @CNT) END
WHERE  qtstratum = 0

GO
